 ; Ŀ
 ;   Yum - maintain a database of tb data from drawings.                   
 ;   Copyright 2005, 2007 by Rocket Software Ltd.                          
 ;   Some of the subroutines herein are disturbingly similar to ones       
 ;   Used by Trout.lsp.  Currently the two sets match, but these are       
 ;   separate because the file is liable to be modified, data extraction   
 ;   being a moving target, so be careful.  The subroutine Trutta matches  
 ;   the subroutine Trout in Trout.lsp.                                    
 ;   Also note that this stuff will be hard to check - one can test for    
 ;   missing files, but this will report multiple drawings in one file     
 ;   as missing files.                                                     
 ;                                                                         
 ; 

 ; Ŀ
 ;   Bulla - write a list of lists to a csv file.                          
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BULLA (lista filnam / fn sub str nxtstr)
  (if (dupcar lista)
      (write-line "\n** Warning: csv file contains duplicate drawing names. **"))
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (setq str "")
         (while (setq nxtstr (car sub))
                (setq sub (cdr sub))
                (setq str (strcat str "," nxtstr)))
         (write-line (substr str 2) fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Bulla end.                                                            
 ; 

 ; Ŀ
 ;   Comba - add a data list to a list of data lists, unless there is an   
 ;   existing sublist in the list of lists with the same first element     
 ;   in which case replace it with the new one.                            
 ;   This means that duplicate drawing names (i.e. leading extracted       
 ;   fields) will be ignored.                                              
 ;   Arguments: Gnulst, the new data list.                                 
 ;              Csvlst, the list of data lists from the cdf/csv file.      
 ;   Calls nothing, returns a combined data list.                          
 ; 
 (DEFUN COMBA (gnulst csvlst / poso asoca)
  (setq poso (car gnulst))
 ; Ŀ
 ;   See if csvlst has a sublist with the same first element as gnulst.    
 ; 
  (if (setq asoca (assoc poso csvlst))
 ; Ŀ
 ;   If so then swap the new list for the old one.  Note that subst        
 ;   will do every occurrence in the list, which shouldn't be a            
 ;   problem because there shouldn't be duplicate drawing names.           
 ;   At least in theory...                                                 
 ; 
      (setq csvlst (subst gnulst asoca csvlst))
 ; Ŀ
 ;   If not then append gnulst to csvlst.                                  
 ; 
      (setq csvlst (append csvlst (list gnulst))))
 csvlst)
 ; Ŀ
 ;   Comba end.                                                            
 ; 

 ; Ŀ
 ;   Dalbe - get data from an ss of blocks.                                
 ;   The argument Rqlist is a list which contains, in order:               
 ;        An ss of block enames.                                           
 ;        A list of attribute names to extract.  Any attribute names       
 ;          which are not found in the block insertion are used as values, 
 ;          which allows one to insert spaces and commas as required.      
 ;          (Or in fact any string which doesn't match an attribute tag.)  
 ;        The number of blocks to find, -1 = all.                          
 ;   Calls Extac and nocomma.                                              
 ;   Returns a list of comma delimited strings.                            
 ; 
 (DEFUN DALBE (rqlst / ss attlst numble count enam atnum attnam strval curstr
                                                                       malist)
  (setq ss (car rqlst))
  (setq attlst (cadr rqlst))
  (setq numble (nth 2 rqlst))
  (setq count 0)
  (while (and (setq enam (ssname ss count))
              (or (minusp numble) (< count numble)))
         (setq curstr "")
         (setq count (1+ count))
         (setq atnum 0)
         (while (setq attnam (nth atnum attlst))
                (setq atnum (1+ atnum))
                (if (setq strval (extac enam attnam))
                    (setq strval (nocomma strval))
                    (setq strval attnam))
                (setq curstr (strcat curstr strval)))
         (setq malist (cons curstr malist)))
 malist)
 ; Ŀ
 ;   Dalbe end.                                                            
 ; 

 ; Ŀ
 ;   Dupcar - see if a list of lists contains any sublists with            
 ;   duplicate first elements.                                             
 ;   Arguments: Lisa, A list.                                              
 ;   Returns a list of duplicate first elements or nil if none were found. 
 ; 
 (DEFUN DUPCAR (lisa / sub duplis)
  (while (setq sub (caar lisa))
         (setq lisa (cdr lisa))
         (if (assoc sub lisa)
             (setq duplis (cons sub duplis))))
 duplis)
 ; Ŀ
 ;   Dupcar end.                                                           
 ; 

 ; Ŀ
 ;   Extac - extract an attribute value from a block insertion.            
 ;   Arguments: Enam, the block insertion entity name.                     
 ;              Atta, the attribute tag.                                   
 ;   Assumes that the block contains attributes, and that only one of      
 ;   them has that tag (or that we only want to extract the first one.)    
 ;   Returns nil if no value was found.                                    
 ; 
 (DEFUN EXTAC (enam atta / vall stop entt tagg)
  (while (and (null stop)
              (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                              (setq enam (entnext enam))))))))
         (setq tagg (cdr (assoc 2 entt)))
         (if (= tagg atta)
             (progn
                  (setq stop t)
                  (setq vall (cdr (assoc 1 entt))))))
 vall)
 ; Ŀ
 ;   Subroutine Extac end.                                                 
 ; 

 ; Ŀ
 ;   Flout - suck a text file into a list of lists of strings.             
 ;   Arguments: filnam, a filename.                                        
 ;   Calls Sub1.                                                           
 ;   Returns a list: (("up-to-first-comma" "rest") ... )                   
 ;   If there is no comma then the sublist is: ("string" "").              
 ; 
 (DEFUN FLOUT (filnam / fn linn malist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (if (/= linn "")
                      (setq malist (append malist (list (sub1 linn))))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Flout end.                                                            
 ; 

 ; Ŀ
 ;   Nocomma - returns a string minus the commas.                          
 ; 
 (DEFUN NOCOMMA (aa / pos len bb)
  (setq pos 1)
  (setq len (strlen aa))
  (while (>= len pos)
         (setq bb (substr aa pos 1))
         (if (= bb ",")
             (setq aa (strcat (substr aa 1 (1- pos))
                              (substr aa (1+ pos)))))
         (setq pos (1+ pos)))
  aa)
 ; Ŀ
 ;   Nocomma end.                                                          
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the path or the extension.  
 ; 
 (DEFUN NOPATH (/ tt pos ff)
 ; Ŀ
 ;   Save this next bit in case we want the path too.                      
 ; 
 ; (setq tt (strcat (getvar "dwgprefix") (getvar "dwgname")))
 ; Ŀ
 ;   Get drawing name with path and set pointer Pos to end of string.      
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove the path.                                                      
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 ; Ŀ
 ;   Remove the extension.                                                 
 ; 
  (if (= (substr (strcase tt t) (- (setq len (strlen tt)) 3)) ".dwg")
          (setq tt (substr tt 1 (- len 4))))
  tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Sub1 - split a text string at the first comma.             
 ;   Argument: Linn, a text string.                                        
 ;   Returns a list of substrings.                                         
 ;   If there is no comma in the string returns ("string" "").             
 ; 
 (DEFUN SUB1 (linn / len pos name1 strlst)
  (setq pos 1)
  (setq len (strlen linn))
  (while (and (/= (substr linn pos 1) ",")
              (>= len pos))
         (setq pos (1+ pos)))
  (setq name1 (substr linn 1 (1- pos)))
  (setq linn (substr linn (1+ pos)))
 (list name1 linn))
 ; Ŀ
 ;   Sub1 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Trutta - get a list of title block data strings.           
 ;   Takes no arguments.                                                   
 ;   Uses an internal list of title blocks and desired data.               
 ;   Calls Nopath, Dalbe/Extac & Nocomma.                                  
 ;   Returns a list of strings, one for each tb in the drawing.            
 ; 
 (DEFUN TRUTTA (/ fileno tblisi num blist ss datlst stop)
 ; Ŀ
 ;   Get the current drawing file name.                                    
 ; 
  (setq fileno (nopath))
 ; Ŀ
 ;   Make the list of blocks and data to extract.  Note that anything      
 ;   which isn't an an attribute tag (i.e. one found in the block) is      
 ;   added directly to the data string returned by Dalbe.  This includes   
 ;   commas and the second element which is the file name.                 
 ;   If we are keying csv lines off the file name then multiple title      
 ;   blocks extracted from one drawing won't be written to the file.       
 ;   Must make the drawing name the second field, which means passing it   
 ;   to Dalbe as a string and hoping that it doesn't duplicate an          
 ;   attribute tag, which admittedly looks unlikely.                       
 ; 
  (setq tblisi (list
   (list "fci-encana" (list fileno "," "TITLE2" "," "TITLE" "," "TITLE3"
                                   "," "REVISION") -1)
   (list "gca1tb"     (list fileno "," "LINE1" "," "LINE2" "," "LINE3"
                                   "," "TBREV") -1)
   (list "gca3ltb"    (list fileno "," "LINE1" "," "LINE2" "," "LINE3"
                                   "," "Line1-2" "," "Line2-2" "," "TBREV") -1)
   (list "coltma1c"   (list fileno "," "TITLE1" "," "TITLE2" "," "TITLE3"
                                   "," "REV") -1)
   (list "geielctb"   (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "gela1tb"    (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "geia1tb"    (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "geia0tb"    (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "gca3-cad"   (list fileno "," "LINE1" "," "LINE2" "," "LINE3"
                                   "," "Line1-2" "," "Line2-2" "," "TBREV") -1)
   (list "geia3itb"   (list fileno "," "TITLE_1ST_3LINE" "," "TITLE_1ST_2LINE"
                                   "," "TITLE_2ND_3LINE" "," "TITLE_2ND_2LINE"
                                   "," "TITLE_3RD_3LINE" "," "REV") -1)
   (list "geia3ltb"   (list fileno "," "TITLE_1ST_3LINE" "," "TITLE_1ST_2LINE"
                                   "," "TITLE_2ND_3LINE" "," "TITLE_2ND_2LINE"
                                   "," "TITLE_3RD_3LINE" "," "REV") -1)
   (list "maintb"     (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "titl-d2"    (list "DRAWINGNO" "," fileno "," "TITLE1" " " "TITLE2"
                            "," "MAINREV") -1)))
 ; Ŀ
 ;   Try to find a title block, call the data extraction subroutine.       
 ; 
  (setq num 0)
  (while (and (null stop)
              (setq blist (nth num tblisi)))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (cons 2 (car blist)))))
             (progn
                  (setq datlst (dalbe (cons ss (cdr blist))))
                  (setq stop T))))
 ; Ŀ
 ;   If no block was found, make an error string.                          
 ; 
  (if (null stop)
      (setq datlst (list (strcat fileno ",No Data Available"))))
 datlst)
 ; Ŀ
 ;   Subroutine Trutta end.                                                
 ; 

 ; Ŀ
 ;   Yum.                                                                  
 ; 
 (DEFUN C:YUM (/ filnam *error* lista fnam exlist)
  (setvar "cmdecho" 0)
  (setq filnam "Filedata.csv")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk) (print shk) (princ))
 ; Ŀ
 ;   Get the data for the current drawing.                                 
 ; 
  (setq lista (trutta))
  (if (> (setq lena (length lista)) 1)
      (write-line (strcat "\n** Caution: this drawing contains "
                          (itoa lena) " title blocks. **")))
 ; Ŀ
 ;   Rehash the list so that leading csv fields can be compared.           
 ; 
  (setq lista (mapcar 'sub1 lista))
  (if (dupcar lista)
      (write-line "\n** Warning: duplicate drawing names in this file were not recorded. **"))
 ; Ŀ
 ;   Get a filename to write the data out to.                              
 ; 
  (if (setq fnam (findfile (strcat (getvar "dwgprefix") filnam)))
 ; Ŀ
 ;   If the file exists, read it into its own list.                        
 ; 
      (progn
           (setq exlist (flout fnam))
 ; Ŀ
 ;   Combine the file list and the drawing list.                           
 ; 
           (setq num 0)
           (while (setq sub (nth num lista))
                  (setq num (1+ num))
                  (setq exlist (comba sub exlist)))
 ; Ŀ
 ;   Write the list to the csv file.                                       
 ; 
           (bulla exlist fnam))
 ; Ŀ
 ;   If the file doesn't exist then make one.                              
 ; 
      (progn
           (setq fnam (strcat (getvar "dwgprefix") filnam))
           (bulla lista fnam)))
 (princ))